/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2002-05-27
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LEGENDTABLE_H
#define LEGENDTABLE_H

#include <QGpGuiTools.h>

#include "Symbol.h"
#include "Legend.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

class SCIFIGS_EXPORT LegendTable : public QTableView
{
  Q_OBJECT
public:
  enum Column {ColumnNull,
               ColumnPenColor, ColumnPenWidth, ColumnPenStyle,
               ColumnSymbolType, ColumnSymbolSize,
               ColumnSymbolPenColor, ColumnSymbolPenWidth, ColumnSymbolPenStyle,
               ColumnSymbolBrushColor, ColumnSymbolBrushStyle,
               ColumnTextColor, ColumnText};
  enum PropertySection {All = 0x3F, Text = 0x01, Pen = 0x02, SymbolAll=0x1C,
                        SymbolType = 0x04, SymbolPen = 0x08, SymbolBrush = 0x10, TextColor=0x20, TextAll=0x21};
  Q_DECLARE_FLAGS(PropertySections, PropertySection)

  LegendTable( QWidget *parent = 0 );

  void setLegend( Legend * legend );
  void setPropertySections( PropertySections s = All );

  void setOneColor( bool oc );
  bool oneColor() const;

  void setReadOnlyText( bool ro );
  bool readOnlyText() const;

  void setConstant( bool c );

  static void initPenStyles( QComboBox * w );
  static Qt::PenStyle penStyle( int index );
  static void initSymbolTypes( QComboBox * w );
  static Symbol::Type symbolType( int index );
  static void initBrushStyles( QComboBox * w );
  static Qt::BrushStyle brushStyle( int index );
private slots:
  void applyAllSelected();
signals:
  void changed();
private:
  static QPixmap penStylePixmap( Qt::PenStyle s );
  static QPixmap brushStylePixmap( Qt::BrushStyle s );
  static QPixmap symbolTypePixmap( Symbol::Type t );

  QHash<int,Column> _columnIndexes;
};

} // namespace SciFigs

Q_DECLARE_OPERATORS_FOR_FLAGS(SciFigs::LegendTable::PropertySections)

#endif // LEGENDTABLE_H
