/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-03-19
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LEGENDTABLEDELEGATE_H
#define LEGENDTABLEDELEGATE_H

#include "SciFigsDLLExport.h"
#include "LegendTable.h"

namespace SciFigs {

class SCIFIGS_EXPORT LegendTableDelegate : public QItemDelegate
{
  Q_OBJECT
public:
  LegendTableDelegate(QObject * parent=0) : QItemDelegate( parent ) {}

  void setColumnIndexes( const QHash<int,LegendTable::Column> * columnIndexes );

  virtual QWidget *createEditor( QWidget *parent, const QStyleOptionViewItem &option,
                                 const QModelIndex &index ) const;
  virtual void setEditorData( QWidget *editor, const QModelIndex &index ) const;
  virtual void setModelData( QWidget *editor, QAbstractItemModel *model,
                             const QModelIndex &index ) const;
  virtual QSize sizeHint ( const QStyleOptionViewItem & option, const QModelIndex & index ) const;
  virtual void paint ( QPainter * painter, const QStyleOptionViewItem & option,
                       const QModelIndex & index ) const;
public slots:
  void colorClicked(const QModelIndex& index);
private slots:
  void commitWidget(QWidget * w=0);
signals:
  void dataChanged() const;
private:
  LegendTable::Column column( int index ) const;
  const QHash<int,LegendTable::Column> * _columnIndexes;
  mutable QModelIndex _colorIndex;
};

} // namespace SciFigs

#endif // LEGENDTABLEDELEGATE_H
