/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-03-19
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LEGENDTABLEITEM_H
#define LEGENDTABLEITEM_H

#include "LegendTable.h"

namespace SciFigs {

class LegendTableItem : public QAbstractTableModel
{
  Q_OBJECT
public:
  LegendTableItem( QObject * parent = 0 );

  void setLegend( Legend * legend );
  void setColumnIndexes( const QHash<int,LegendTable::Column> * columnIndexes );

  void setReadOnlyText( bool ro ) { _readOnlyText = ro; }
  bool readOnlyText() const { return _readOnlyText; }

  void setOneColor( bool oc ) { _oneColor = oc; }
  bool oneColor() const { return _oneColor; }

  virtual int rowCount( const QModelIndex &parent = QModelIndex() ) const;
  virtual int columnCount( const QModelIndex &parent = QModelIndex() ) const;
  virtual QVariant data( const QModelIndex &index, int role ) const;
  virtual bool setData ( const QModelIndex & index, const QVariant & value, int role = Qt::EditRole );
  virtual Qt::ItemFlags flags ( const QModelIndex & ) const;
private:
  void setColor( int row, const QColor& c );
  LegendTable::Column column( int index ) const;
  const QHash<int,LegendTable::Column> * _columnIndexes;

  int _readOnlyText:1;
  int _oneColor:1;

  Legend * _legend;
};

} // namespace SciFigs

#endif // LEGENDTABLEITEM_H
