/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-10-25
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LINEEDITOR_H
#define LINEEDITOR_H

#include <QGpCoreTools.h>

#include "SciFigsDLLExport.h"

namespace SciFigs {

class LineLayer;

class SCIFIGS_EXPORT LineEditor
{
public:
  LineEditor( LineLayer * layer );
  ~LineEditor();

  bool mousePressEvent( QMouseEvent * e );
  void mouseMoveEvent ( const QPoint& pt );
  void wheelEvent ( QWheelEvent * e );

  int lineIndex() const {return _lineIndex;}
private:
  void saveOriginal();
  void restoreOriginal();
  void setDeformation();
  void pointAt( const QPoint& pScreen );
  void deformLine();

  LineLayer * _layer;
  int _lineIndex;
  int _pointIndex;
  int _count;
  double _dx, _dy;
  bool _deformZ;
  Point * _original;
  // Gaussian deformation
  double _deformationWidth;
  double * _deformation;
};

} // namespace SciFigs

#endif // LINEEDITOR_H
