/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-11-03
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LINEFACTORY_H
#define LINEFACTORY_H

#include <QGpCoreTools.h>

#include "SciFigsDLLExport.h"

namespace SciFigs {

#define REGISTER_LINE( _className_, _tagName_ ) \
  XMLREGISTER_HEAD( "Line", XMLClassCreator, _className_, _tagName_) \
  XMLREGISTER_TAIL( _className_)

#define SYNONYM_LINE( _synName_, _tagName_ ) \
  XMLSYNONYM( "Line", _synName_, _tagName_ )

class SCIFIGS_EXPORT LineFactory : public XMLClassFactory
{
public:
  XMLClass * create( QString tag ) {
    return XMLClassFactory::create("Line", tag );
  }
  static LineFactory * instance() {
    return reinterpret_cast<LineFactory *>(& _self);
  }
};

} // namespace SciFigs

#endif // LINEFACTORY_H
