/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-05-11
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LIVEGRIDLAYER_H
#define LIVEGRIDLAYER_H

#include <QGpCoreTools.h>

#include "SciFigsDLLExport.h"
#include "IrregularGrid2DPlot.h"
#include "GridPlot.h"

namespace SciFigs {

class LiveGridLayerProperties;

class SCIFIGS_EXPORT LiveGridLayer : public GridPlot
{
  Q_OBJECT
public:
  LiveGridLayer( AxisWindow * parent );
  ~LiveGridLayer();

  virtual const QString& xml_tagName() const {return IrregularGrid2DPlot::xmlIrregularGrid2DPlotTag;}

  void setFunction( AbstractFunction2 * f );
  AbstractFunction2 * takeFunction();
  const AbstractFunction2 * function() const { return _function; }

  bool autoAdjustPalette() const { return _autoAdjustPalette; }
  void setAutoAdjustPalette( bool a ) { _autoAdjustPalette = a; }

  bool forceMinimumValue() const { return _forceMinimumValue; }
  void setForceMinimumValue( bool f ) { _forceMinimumValue = f; }

  double minimumValue() const { return _minimumValue; }
  void setMinimumValue( double m ) { _minimumValue = m; }

  bool forceMaximumValue() const { return _forceMaximumValue; }
  void setForceMaximumValue( bool f ) { _forceMaximumValue = f; }

  double maximumValue() const { return _maximumValue; }
  void setMaximumValue( double m ) { _maximumValue = m; }

  Sampling::Type scale() const { return _scale; }
  void setScale( Sampling::Type s ) {  _scale = s; }

  void setSampling( int s ) { _sampling = s; }
  int sampling() const { return _sampling; }

  void setSmallestDetail(double d) {_smallestDetail=d;}
  int smallestDetail() const {return _smallestDetail;}

  virtual bool hasProperties() { return true; }
  virtual void addProperties( PropertyProxy * pp );
  virtual void removeProperties( PropertyProxy * pp );
  virtual void properties( PropertyWidget * w ) const;
  virtual void setProperty( uint wid, int pid, QVariant val );

  virtual Rect boundingRect() const;
private slots:
  void showAdjustedPalette( const ColorPalette& pal );
signals:
  void paletteAdjusted( const ColorPalette& pal ) const;
protected:
  virtual void paintData( const LayerPainterRequest& lp, QPainter& p, double dotpercm ) const;
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;

  AbstractFunction2 * _function;
  int _sampling;
  double _smallestDetail;
private:
  IrregularGrid2D calculateGrid( const QSize& s, const GraphContentOptions& gc,
                                    const LayerPainterRequest * lp = 0) const;
  void adjustPalette( const IrregularGrid2D& grid, ColorPalette& pal ) const;
  //inline void fillRow( GraphContent * gc, uint *& imPtr, double y, int w, int w1 ) const;
  //inline void fillRowSup1( GraphContent * gc, uint *& imPtr, double y, int w, int w1 ) const;
  //inline void fillRowSup2( GraphContent * gc, uint *& imPtr, double y, int w, int w1 ) const;

  uint _autoAdjustPalette:1;
  uint _forceMinimumValue:1;
  uint _forceMaximumValue:1;
  Sampling::Type _scale:2;
  double _minimumValue, _maximumValue;
  static uint _tab;
};

} // namespace SciFigs

#endif // LIVEGRIDLAYER_H
