/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-11-25
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MAKEUPFILTER_H
#define MAKEUPFILTER_H

#include <QGpGuiTools.h>
#include "ui_MakeUpFilter.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

class SCIFIGS_EXPORT MakeUpFilter : public Dialog, private Ui::MakeUpFilter
{
  Q_OBJECT
public:
  MakeUpFilter( QWidget * parent=0 );
  ~MakeUpFilter();

  void setXml( QString xml );
  QString saveString() const;
  QByteArray saveByteArray() const;
  void saveFile(QString fileName) const;
private slots:
  void on_customFilter_toggled();
  void on_printX_toggled();
  void on_printY_toggled();
  void on_titleX_toggled();
  void on_titleY_toggled();
  void on_rangeX_toggled();
  void on_rangeY_toggled();
  void on_layers_toggled();
private:
  void updateFields();

  int _expandedHeight;
};

} // namespace SciFigs

#endif // MAKEUPFILTER_H
