/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2004-10-07
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef NAMELINE_H
#define NAMELINE_H

#include "AbstractNameLine.h"

namespace SciFigs {

class SCIFIGS_EXPORT NameLine : public AbstractNameLine
{
public:
  virtual AbstractLine * clone() const;
  void operator=(const NameLine& o);

  virtual const QString& xml_tagName() const {return xmlNameLineTag;}
  static const QString xmlNameLineTag;

  virtual int count() const { return _curve.count(); }
  virtual void clear() { _curve.clear(); }
  virtual void append() { _curve.append( NamedPoint() ); }
  virtual void insert( int index ) { _curve.insert( index, NamedPoint() ); }
  virtual void removeLast() {  _curve.remove( _curve.count()-1 ); }
  virtual Point point( int index ) const { return _curve.at( index ); }
  virtual QString name( int index ) const { return _curve.at( index ).name(); }
  virtual void setX( int index, double v ) { _curve[ index ].setX( v ); }
  virtual void setY( int index, double v ) { _curve[ index ].setY( v ); }
  virtual void setZ( int index, double v ) { _curve[ index ].setZ( v ); }
  virtual void setName( int index, QString n ) { _curve[ index ].setName( n ); }

  const Curve<NamedPoint>& curve() const { return _curve; }
  Curve<NamedPoint>& curve() { return _curve; }
protected:
  Curve<NamedPoint> _curve;
};

} // namespace SciFigs

#endif // NAMELINE_H
