/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2003-04-04
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef NAMELINELAYER_H
#define NAMELINELAYER_H

#include "LineLayer.h"
#include "NameLine.h"

namespace SciFigs {

class NameLineLayerProperties;

class SCIFIGS_EXPORT NameLineLayer : public LineLayer
{
  Q_OBJECT
  Q_PROPERTY( bool showNames READ isShowNames WRITE setShowNames SCRIPTABLE true )
  Q_PROPERTY( QString font READ fontString WRITE setFontString SCRIPTABLE true )
public:
  NameLineLayer( AxisWindow * parent = 0 );
  ~NameLineLayer();

  virtual const QString& xml_tagName() const { return xmlNameLineLayerTag;}
  static const QString xmlNameLineLayerTag;

  void setNames( int i, QVector<QString> * names );

  bool isShowNames() const { return _showNames; }
  void setShowNames( bool b ) { _showNames = b; }

  QString fontString() const { return _textFont.toString(); }
  void setFontString( QString fs ) { _textFont.fromString( fs ); }

  virtual bool hasProperties() { return true; }
  virtual void addProperties( PropertyProxy * pp );
  virtual void removeProperties( PropertyProxy * pp );
  virtual void properties( PropertyWidget * w ) const;
  virtual void setProperty( uint wid, int pid, QVariant val );

  inline AbstractNameLine * addLine();
  inline AbstractNameLine * addLine( const Pen& pen, const Symbol& sym );

  inline AbstractNameLine * line( int i );
  inline const AbstractNameLine * line( int i ) const;

  virtual Legend legend() const;
  virtual void setLegend( Legend legend );
protected:
  virtual void paintData( const LayerPainterRequest& lp, QPainter& p, double dotpercm ) const;
  virtual void paintText( const LayerPainterRequest& lp, double dotpercm );

  bool _showNames;
  QFont _textFont;

  static uint _tab;
private:
  inline void drawLabel( QPainter& p, const QPainterPath& name, const Angle& angle, const QRectF& r, int baseLine ) const;
  QList<QPainterPath> _textPaths;
  mutable QMutex _textPathsMutex;
};

inline AbstractNameLine * NameLineLayer::addLine()
{
  return static_cast<AbstractNameLine *>( LineLayer::addLine() );
}

inline AbstractNameLine * NameLineLayer::addLine( const Pen& pen, const Symbol& sym )
{
  return static_cast<AbstractNameLine *>( LineLayer::addLine( pen, sym ) );
}

inline AbstractNameLine * NameLineLayer::line( int i )
{
  return static_cast<AbstractNameLine *>( LineLayer::line( i ) );
}

inline const AbstractNameLine * NameLineLayer::line( int i ) const
{
  return static_cast<const AbstractNameLine *>( LineLayer::line( i ) );
}

} // namespace SciFigs

#endif // NAMELINELAYER_H
