/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-09-26
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PALETTEINTERPOLE_H
#define PALETTEINTERPOLE_H

#include <QGpGuiTools.h>
#include "ui_PaletteInterpole.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

class Legend;

class SCIFIGS_EXPORT PaletteInterpole : public Dialog, public Ui::PaletteInterpole
{
  Q_OBJECT
public:
  PaletteInterpole( QWidget * parent=0 ) : Dialog(parent) { setupUi(this); }

  void setColors( const ColorPalette& pal );
  void setValues( const ColorPalette& pal );
  void setColors( const Legend& leg );

  int fromIndex() const;
  int toIndex() const;
private slots:
  void on_firstEntry_clicked();
  void on_lastEntry_clicked();
};

} // namespace SciFigs

#endif // PALETTEINTERPOLE_H
