/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-07-04
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PALETTEPROPERTIES_H
#define PALETTEPROPERTIES_H

#include "ui_PaletteProperties.h"

namespace SciFigs {

class ColorPaletteWidget;
class GraphicObject;

class PaletteProperties : public PropertyWidget, private Ui::PaletteProperties
{
  Q_OBJECT
public:
  PaletteProperties( QWidget * parent=0 );

  enum Properties { Palette };
private:
  virtual int determineCustomWidgetType( int pid, QWidget * w, QWidget * label );
  virtual bool connectCustomWidget( PropertyValue & );
  virtual QVariant customWidgetValue( PropertyValue & );
  virtual bool setCustomWidget( PropertyValue &  p );
private slots:
  void on_loadPalette_clicked();
  void on_savePalette_clicked();
  void on_linearValues_clicked();
  void on_logValues_clicked();
  void on_interpoleColors_clicked();
  void on_grayColors_clicked();
  void on_colorColors_clicked();
  void on_colorNumber_valueChanged();
};

} // namespace SciFigs

#endif // PALETTEPROPERTIES_H
