/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2002-05-27
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PALETTETABLE_H
#define PALETTETABLE_H

#include <QtGui>
#include <QGpGuiTools.h>
#include "SciFigsDLLExport.h"

namespace SciFigs {

class SCIFIGS_EXPORT PaletteTable : public QScrollArea
{
  Q_OBJECT
public:
  PaletteTable(QWidget *parent=0);

  void setValues( const ColorPalette& pal );
  void setColors( const ColorPalette& pal );

  void setColorCount( int newNumber );

  double value( int i ) const;
  ColorPalette palette() const;

  void setConstant( bool c );
signals:
  void changed();
protected:
  virtual void resizeEvent(QResizeEvent * e);
private:
  QList<ColorButton *> _colors;
  QList<QLineEdit *> _values;
};

} // namespace SciFigs

#endif // PALETTETABLE_H
