/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-03-23
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SCIFIGSPLUGIN_H
#define SCIFIGSPLUGIN_H

#include <QGpCoreTools.h>
#include "SciFigsDLLExport.h"
#include "SciFigsVersion.h"

namespace SciFigs {

class SCIFIGS_EXPORT SciFigsPlugin : public QObject
{
  Q_OBJECT
public:
  virtual ~SciFigsPlugin() {}

  virtual QString tag() const = 0;
  virtual QString title() const = 0;
  virtual QString description() const {return QString::null;}

  static QStringList getPluginList(QStringList libs, bool& ok, bool debug = false);
  static bool loadPlugins(QStringList libs, bool debug = false);
  static SciFigsPlugin * loadPlugin(QString pluginFile, bool debug = false);

  bool isValid() const;
  virtual const char * interfaceVersion() const = 0;
};

} // namespace SciFigs

Q_DECLARE_INTERFACE( SciFigs::SciFigsPlugin, "org.geopsy.SciFigsPlugin/1.0" );

#endif // SCIFIGSPLUGIN_H
