/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-03-23
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SCIFIGSPREFERENCES_H
#define SCIFIGSPREFERENCES_H

#include <QGpGuiTools.h>

#include "ui_SciFigsPreferences.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

class SCIFIGS_EXPORT SciFigsPreferences : public Dialog, public Ui::SciFigsPreferences
{
  Q_OBJECT
public:
  SciFigsPreferences(QWidget* parent=0, Qt::WFlags fl=0);
  ~SciFigsPreferences();

  void savePluginList();
public slots:
  void on_searchPlugin_clicked();
  void on_addPath_clicked();
  void on_removePath_clicked();
private:
  QStringList getPaths();
  QStringList getPluginList();
  void setPluginList( QStringList libs );
};

} // namespace SciFigs

#endif // SCIFIGSPREFERENCES_H
