/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-11-03
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef STATLINE_H
#define STATLINE_H

#include "AbstractLine.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

class SCIFIGS_EXPORT StatLine : public AbstractLine
{
public:
  virtual AbstractLine * clone() const;
  virtual void operator=(const StatLine& o);

  virtual const QString& xml_tagName() const {return xmlStatLineTag;}
  static const QString xmlStatLineTag;

  virtual int count() const { return _curve.count(); }
  virtual void clear() { _curve.clear(); }
  virtual void append() { _curve.append( StatPoint() ); }
  virtual void insert( int index ) { _curve.insert( index, StatPoint() ); }
  virtual void removeLast() { _curve.remove( _curve.count()-1 ); }
  virtual bool isValid( int index ) const { return _curve[index].isValid(); }
  virtual void setValid( int index, bool v) { _curve[index].setValid(v); }
  virtual Point point( int index ) const;
  virtual void setX( int index, double v ) { _curve[index].setX(v); }
  virtual void setY( int index, double v ) { _curve[index].setMean(v); };
  virtual void setZ( int index, double v ) { _curve[index].setStddev(v); };

  const Curve<StatPoint>& curve() const { return _curve; }
  Curve<StatPoint>& curve() { return _curve; }
  void setCurve( const Curve<StatPoint>& curve ) { _curve = curve; }
protected:
  Curve<StatPoint> _curve;
};

} // namespace SciFigs

#endif // STATLINE_H
