/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-11-03
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef STATPROXY_H
#define STATPROXY_H

#include "CurveBrowserSimpleProxy.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

class SCIFIGS_EXPORT StatProxy : public CurveBrowserSimpleProxy
{
  TRANSLATIONS("StatProxy")
public:
  virtual QString tag() const { return "StatProxy"; }

  virtual int sampleCount( int index ) const;
  virtual void setFunction( int index );
  virtual double minimumX( int index ) const;
  virtual double maximumX( int index ) const;
  virtual double minimumY( int index ) const;
  virtual double maximumY( int index ) const;
  virtual bool isValid( int index, int sample ) const;
  virtual void setValid( int index, int sample, bool v );
  virtual void cut( int index, double min, double max, SamplingOptions options );
  virtual void resample( int index, int n, double min, double max,
                         SamplingOptions options,
                         double valX, double valY );
  virtual void resample( int index, int n, double min, double max,
                         SamplingOptions options );
  virtual void average( int index, int indexOther );

  virtual int columnCount() const { return 4; }
  virtual QString columnName( int col ) const;
  virtual QString columnUnit( int col ) const;

  virtual QVariant columnValue( int index, int sample, int col ) const;
  virtual void setColumnValue( int index, int sample, int col, const QVariant & value );

  virtual int xAxisColumn() const { return 0; }
  virtual int xAxisInversedColumn() const  { return -1; }
  virtual int yAxisColumn() const { return 1; }
  virtual int yAxisInversedColumn() const { return -1; }

  virtual QStringList columnFileTypes() const;
  virtual QVector<int> defaultColumnFileTypes() const;
  virtual QVector<int> savedColumns() const;

  virtual void parse(int index, ColumnTextIterator& it);
protected:
  const Curve<StatPoint>& curve( int index ) const;
  Curve<StatPoint>& curve( int index );
};

} // namespace SciFigs

#endif // STATPROXY_H
