/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-08-23
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef XUNIQUEYCOLORLINES_H
#define XUNIQUEYCOLORLINES_H

#include "GraphContentLayer.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

class XYColorLinesProperties;

class SCIFIGS_EXPORT XUniqueYColorLines : public GraphContentLayer
{
  Q_OBJECT
  Q_PROPERTY(double lineWeight READ lineWeight WRITE setLineWeight SCRIPTABLE true )
public:
  XUniqueYColorLines( AxisWindow * parent = 0 );
  ~XUniqueYColorLines();

  virtual const QString& xml_tagName() const {return xmlXUniqueYColorLinesTag;}
  static const QString xmlXUniqueYColorLinesTag;

  void clear();
  void setPointCount( int nCurve, int nX );

  const double * x() const { return _x;}
  const double * y() const { return _y;}
  double * x() { return _x;}
  double * y() { return _y;}

  const QColor * colors() const { return _colors;}
  void setColors( QColor * col );
  void setColor( int index, const QColor& col );

  // Calculate the rectangle that includes all the curves
  Rect boundingRect() const;

  virtual bool trackRectangle( int, double rx1, double ry1, double rx2, double ry2, Qt::KeyboardModifiers );
  int curveCount() { return _curveCount;}
  inline void setLineWeight( double lw ) {_lineWeight = lw;}
  double lineWeight() const { return _lineWeight;}
  double lineWeightMM() const { return _lineWeight*10.0;}
  void mulYbyX( double constant );
  void divYbyX( double constant );

  virtual bool hasProperties() { return true; }
  virtual void addProperties( PropertyProxy * pp );
  virtual void removeProperties( PropertyProxy * pp );
  virtual void properties( PropertyWidget * w ) const;
  virtual void setProperty( uint wid, int pid, QVariant val );
public slots:
  void setColor(int curveIndex, int red, int green, int blue);
signals:
  void dataSelected( int id, const QVector<int> * indexList );
protected:
  virtual void paintData( const LayerPainterRequest& lp, QPainter& p, double dotpercm ) const;

  int _curveCount;
  int _xCount;
  double * _x;
  double * _y;
  QColor * _colors;
  // Line weight in cm
  double _lineWeight;
  // Storage for pointer to tab widget
  XYColorLinesProperties * _propertiesTab;
protected:
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual void xml_writeBinaryData(XML_WRITEBINARYDATA_ARGS) const;
  virtual bool xml_setBinaryData(XML_SETBINARYDATA_ARGS);
};

} // namespace SciFigs

#endif // XUNIQUEYCOLORLINES_H
