/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2002-05-28
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef XYCOLORLINES_H
#define XYCOLORLINES_H

#include <QGpGuiTools.h>

#include "GraphicObject.h"
#include "GraphContentLayer.h"

namespace SciFigs {

class XYColorLinesProperties;

class SCIFIGS_EXPORT XYColorLines : public GraphContentLayer
{
  Q_OBJECT
  Q_PROPERTY(double lineWeight READ lineWeight WRITE setLineWeight SCRIPTABLE true )
public:
  XYColorLines( AxisWindow * parent = 0, bool autoDelete = false );
  ~XYColorLines();

  virtual const QString& xml_tagName() const {return xmlXYColorLinesTag;}
  static const QString xmlXYColorLinesTag;

  Point2D * points() { return _points;}
  const Point2D * points() const { return _points;}

  const QColor * colors() const { return _colors;}
  void setColors( QColor * col );
  void setColor( int index, const QColor& col );

  int curveCount() { return _curveCount; }
  void setPointCount( int nPoints, int nCurves, int * pointCounts );
  void setPointCount( int nPoints, const QVector<int>& pointCounts );
  void setPoints( const QVector<Point2D>& points );

  // Calculate the rectangle that includes all the curves
  Rect boundingRect() const;

  virtual bool trackRectangle( int, double rx1, double ry1, double rx2, double ry2, Qt::KeyboardModifiers );

  void setLineWeight ( double lw );
  double lineWeight() const { return _lineWeight; }
  double lineWeightMM() const { return _lineWeight*10.0; }

  void mulYbyX( double constant );
  void divYbyX( double constant );

  virtual bool hasProperties() { return true; }
  virtual void addProperties( PropertyProxy * pp );
  virtual void removeProperties( PropertyProxy * pp );
  virtual void properties( PropertyWidget * w ) const;
  virtual void setProperty( uint wid, int pid, QVariant val );

  static uint _tab;

  static void saveBinaryColorVector(QDataStream& s, const QColor * colors, int count);
  static void restoreBinaryColorVector(QDataStream& s, QColor *& colors, int count, XMLContext * context);
public slots:
  void setColor(int curveIndex, int red, int green, int blue);
signals:
  void dataSelected( int id, const QVector<int> * indexList );
protected:
  void clear();
  virtual void paintData( const LayerPainterRequest& lp, QPainter& p, double dotpercm ) const;

  bool _autoDelete;
  int _curveCount;
  int * _pointCounts;
  Point2D * _points;
  QColor * _colors;
  // Line weight in cm
  double _lineWeight;
  // Storage for pointer to tab widget
  XYColorLinesProperties * _propertiesTab;
protected:
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual void xml_writeBinaryData(XML_WRITEBINARYDATA_ARGS) const;
  virtual bool xml_setBinaryData(XML_SETBINARYDATA_ARGS);
  virtual bool xml_setBinaryData200411(XML_SETBINARYDATA_ARGS);
};

} // namespace SciFigs

#endif // XYCOLORLINES_H
