/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-12-23
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef XYVALUELINES_H
#define XYVALUELINES_H

#include "XYColorLines.h"

namespace SciFigs {

class PaletteEditor;

class SCIFIGS_EXPORT XYValueLines : public XYColorLines
{
  Q_OBJECT
public:
  XYValueLines( AxisWindow * parent = 0, bool autoDelete = false );
  ~XYValueLines();

  virtual const QString& xml_tagName() const { return xmlXYValueLinesTag;}
  static const QString xmlXYValueLinesTag;

  const ColorPalette& palette() const { return _pal; }
  void setLinearPalette( double minVal, double maxVal );

  double * values() { return _values;}
  void setValues(double * values);
  double * setValues(const QVector<double>& values);
  void valueRange(double& min, double& max) const;

  virtual bool hasProperties() { return true; }
  virtual void addProperties( PropertyProxy * pp );
  virtual void removeProperties( PropertyProxy * pp );
  virtual void properties( PropertyWidget * w ) const;
  virtual void setProperty( uint wid, int pid, QVariant val );
public slots:
  void setPalette( const ColorPalette& pal );
signals:
  void paletteChanged( const ColorPalette& pal );
protected:
  double * _values;
  ColorPalette _pal;
  static uint _tabPalette;

  virtual void paintData( const LayerPainterRequest& lp, QPainter& p, double dotpercm ) const;
  virtual void xml_writeBinaryData( XML_WRITEBINARYDATA_ARGS ) const;
  virtual bool xml_setBinaryData( XML_SETBINARYDATA_ARGS );
  virtual void xml_writeChildren( XML_WRITECHILDREN_ARGS ) const;
  virtual XMLMember xml_member( XML_MEMBER_ARGS );
  virtual void xml_polishChild(XML_POLISHCHILD_ARGS);
};

} // namespace SciFigs

#endif // XYVALUELINES_H
