/***************************************************************************
**
**  This file is part of WaranCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-07-22
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TCPHEADER_H
#define TCPHEADER_H

#include "WaranCoreDLLExport.h"

namespace WaranCore {

class WARANCORE_EXPORT TcpHeader
{
public:
  TcpHeader(unsigned char currentVersion, unsigned char type=0);
  TcpHeader(const TcpHeader& o);

  void operator=(const TcpHeader& o);

  bool isValid() const {return _tag1=='W' && _tag2=='A';}
  bool isCompatible(unsigned char currentVersion) const {return _version<=currentVersion;}
  unsigned char type() const {return _type;}
private:
  char _tag1;
  char _tag2;
  unsigned char _version;
  unsigned char _type;
};

} // namespace WaranCore

#endif // TCPHEADER_H
