
#include <QGpCoreTools.h>

#include "myplugin.h"
#include "forward.h"

/*!
  Unique tag to identify in .report files models generated by this plugin.
*/
QString MyPlugin::tag() const
{
  return "CppTemplate";
}

/*!
  User friendly title, displayed at Dinver startup.
*/
QString MyPlugin::title() const
{
  return "C++ template";
}

QString MyPlugin::version() const
{
  return "1.0.0";
}

/*!
  More explanations about the inversion plugin, displayed in Tooltips at Dinver startup.
*/
QString MyPlugin::description() const
{
  return "<p>Minima of Rastrigin's Function.</p>";
}

/*!
  Creates a forward object, you can initialize its targets and parameters here.
  If the initialization may fail, prefer initForward(). Do not return null.
*/
AbstractForward * MyPlugin::createForward()
{
  return new Forward;
}

/*!
  Optionally initializes targets and parameters of \a forward.
  Returns false if initialization fails.
*/
bool MyPlugin::initForward(AbstractForward * forward)
{
  return true;
}

// Declare this library as a Qt plugin
Q_EXPORT_PLUGIN2( myplugin, MyPlugin );
