# include <stdio.h>
# include "qtbwave.h"

int main()
{
  /* Model */
  int lnum = 2;
  double hl[] = {25,0};
  double vp[] = {800,2500};
  double vs[] = {600,1200};
  double dn[] = {1900,2100};
  int fnum = 100;
  double freq[100];
  int mode = 1;
  double dc[100];

  int nf, nm;

  for (nf=0; nf<fnum; nf++)
    freq[nf] = 1+nf/10;

  for (nm=0; nm<mode; nm++)
    for (nf=0; nf<fnum; nf++)
      dc[nf+nm*fnum] = -1;

  dispersion_curve_init_();
  dispersion_curve_rayleigh_(&lnum,hl,vp,vs,dn,&fnum,freq,&mode,dc);

  for (nm=0; nm<mode; nm++)
    for (nf=0; nf<fnum; nf++)
      printf("%.15lg %.15lg\n",freq[nf],dc[nf+nm*fnum]);
}

