# include "qtbwave.h"
# include "mex.h"

# ifndef max
# define max( a, b ) ( ((a) > (b)) ? (a) : (b) )
# endif

void mexFunction(int nlhs, mxArray *plhs[ ],int nrhs, const mxArray *prhs[ ]) 
{
  /* SETTING INPUT */

  double *hl;
  double *vp;
  double *vs;
  double *dn;

  double *freq;
  double *pmod;

  int lnum;
  int fnum;
  int mode;

  if (nrhs != 6)
    mexErrMsgTxt("Not enough input arguments.");

  if (nlhs != 1)
    mexErrMsgTxt("Too many output arguments.");

  hl = mxGetPr(prhs[0]);
  vp = mxGetPr(prhs[1]);
  vs = mxGetPr(prhs[2]);
  dn = mxGetPr(prhs[3]);

  freq = mxGetPr(prhs[4]);
  pmod = mxGetPr(prhs[5]);

  mode = (int) pmod[0];

  int lval1;
  int lval2;
  int fval1;
  int fval2;

  lval1 = mxGetDimensions(prhs[0])[0];
  lval2 = mxGetDimensions(prhs[0])[1];
  fval1 = mxGetDimensions(prhs[4])[0];
  fval2 = mxGetDimensions(prhs[4])[1];

  lnum = max(lval1,lval2);
  fnum = max(fval1,fval2);

  /* OUTPUT INTIALIZATION */

  int nc;
  double *ell;

  plhs[0] = mxCreateDoubleMatrix(mode*fnum,1,mxREAL);

  ell = mxGetPr(plhs[0]);

  for (nc=0;nc<(mode*fnum);nc++)
    ell[nc] = -1;

  /* RAYLEIGH ELLIPTICITY COMPUTATION */

  /* dispersion_curve_init_(); */
  ellipticity_curve_rayleigh_(&lnum,hl,vp,vs,dn,&fnum,freq,&mode,ell);

  return;
}
