clear all;
close all;

% Setting model
hl = [25 0];
vp = [500 2000];
vs = [200 1000];
dn = [1900 2500];
freq = logspace(log10(0.5),log10(20),1000);
mode = 5;

% Initialization
clear mex;
dispersion_curve_init;

% Call functions
dcl = dispersion_curve_love(hl,vp,vs,dn,freq,mode); clear mex;
dcr = dispersion_curve_rayleigh(hl,vp,vs,dn,freq,mode); clear mex;
ell = ellipticity_curve_rayleigh(hl,vp,vs,dn,freq,mode); clear mex;
pk0 = ellipticity_peak0_rayleigh(hl,vp,vs,dn,freq,mode); clear mex;

return;

% Plot
figure(1);
plot(freq,1./dcl(1:length(freq)));
set(gca,'XScale','Log');
set(gca,'YScale','Log');
axis tight;

figure(2);
plot(freq,1./dcr(1:length(freq)));
set(gca,'XScale','Log');
set(gca,'YScale','Log');
axis tight;

figure(3);
plot(freq,ell(1:length(freq))); hold on;
plot([pk0 pk0],[0.01 100],'r'); hold off;
set(gca,'XScale','Log');
set(gca,'YScale','Log');
axis tight;
