/***************************************************************************
**
**  Copyright (C) 2002-2009 Marc Wathelet. All rights reserved.
**
**  This file is part of qtbwave.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-01-06
**
***************************************************************************
** Modified by Poggi Valerio (poggi@sed.ethz.ch), 2009-10-26
***************************************************************************/

#include "qtbwave.h"
#include "qtbpackageinfo.h"
#include "qtblayeredmodel.h"
#include "qtbrayleigh.h"
#include "qtbdispersion.h"
#include "qtbwaveversion.h"
#include "qtbplugincoreapplication.h"
#include "qtbwaveinstallpath.h"

QTB_PACKAGE_INFO(qtbwave, QTBWAVE);

void dispersion_curve_init_()
{
  new QtbPluginCoreApplication;
}

void dispersion_curve_rayleigh_(int *nLayers, double *h, double *vp, double *vs, double *rho,
                                int *nSamples, double *omega, int *nModes, double *velocity)
{
  QtbLayeredModel m(*nLayers);
  int nLayers1 = *nLayers - 1;

  for (int i=0; i<nLayers1; i++)
  {
    m.setH(i, h[i]);
    m.setSlowP(i,1.0/vp[i]);
    m.setSlowS(i,1.0/vs[i]);
    m.setRho(i,rho[i]);
    m.setQp(i,0.0);
    m.setQs(i,0.0);
  }

  m.setSlowP(nLayers1,1.0/vp[nLayers1]);
  m.setSlowS(nLayers1,1.0/vs[nLayers1]);
  m.setRho(nLayers1,rho[nLayers1]);
  m.setQp(nLayers1,0.0);
  m.setQs(nLayers1,0.0);
  m.initCalculation();

  QtbRayleigh rayleigh(&m);
  QVector<double> x(*nSamples);
  for (int i=0; i<*nSamples; i++)
    x[i] = 2.0*M_PI*omega[i];

  QtbDispersion dispersion(*nModes,&x);
  if (!dispersion.calculate(&rayleigh,0))
    return;

  for(int iMode = 0;iMode<*nModes;iMode++)
  {
    const QtbValue *mode = dispersion.mode(iMode);
    for (int iSample=0; iSample<*nSamples; iSample++)
    {
      if (mode[iSample].isValid())
        *(velocity++) = 1/mode[iSample].value();
      else
        *(velocity++) = -1;
    }
  }
}

void dispersion_curve_love_(int *nLayers, double *h, double *vp, double *vs, double *rho,
                            int *nSamples, double *omega, int *nModes, double *velocity)
{
  QtbLayeredModel m(*nLayers);
  int nLayers1 = *nLayers - 1;

  for (int i=0; i<nLayers1; i++)
  {
    m.setH(i,h[i]);
    m.setSlowP(i,1.0/vp[i]);
    m.setSlowS(i,1.0/vs[i]);
    m.setRho(i,rho[i]);
    m.setQp(i,0.0);
    m.setQs(i,0.0);
  }

  m.setSlowP(nLayers1,1.0/vp[nLayers1]);
  m.setSlowS(nLayers1,1.0/vs[nLayers1]);
  m.setRho(nLayers1,rho[nLayers1]);
  m.setQp(nLayers1,0.0);
  m.setQs(nLayers1,0.0);
  m.initCalculation();

  QtbLove love( &m );
  QVector<double> x(*nSamples);
  for (int i=0; i<*nSamples; i++)
    x[i] = 2.0*M_PI*omega[i];

  QtbDispersion dispersion(*nModes,&x);
  if (!dispersion.calculate(&love,0))
    return;

  for (int iMode=0; iMode<*nModes; iMode++)
  {
    const QtbValue *mode = dispersion.mode(iMode);
    for (int iSample=0; iSample<*nSamples; iSample++)
    {
      if (mode[iSample].isValid())
        *(velocity++) = 1/mode[iSample].value();
      else
        *(velocity++) = -1;
    }
  }
}

void ellipticity_curve_rayleigh_(int *nLayers, double *h, double *vp, double *vs, double *rho,
                                 int *nSamples, double *omega, int *nModes, double *ellcurve)
{
  QtbLayeredModel m(*nLayers);
  int nLayers1 = *nLayers - 1;

  for (int i=0; i<nLayers1; i++)
  {
    m.setH(i, h[i]);
    m.setSlowP(i,1.0/vp[i]);
    m.setSlowS(i,1.0/vs[i]);
    m.setRho(i,rho[i]);
    m.setQp(i,0.0);
    m.setQs(i,0.0);
  }

  m.setSlowP(nLayers1,1.0/vp[nLayers1]);
  m.setSlowS(nLayers1,1.0/vs[nLayers1]);
  m.setRho(nLayers1,rho[nLayers1]);
  m.setQp(nLayers1,0.0);
  m.setQs(nLayers1,0.0);
  m.initCalculation();

  QtbRayleigh rayleigh(&m);
  QVector<double> x(*nSamples);
  for (int i=0; i<*nSamples; i++)
    x[i] = 2.0*M_PI*omega[i];

  QtbDispersion dispersion(*nModes,&x);
  // dispersion.setPrecision( 1e-15 );
  QtbEllipticity ellipticity(*nModes,&x);
  if (!dispersion.calculate(&rayleigh,&ellipticity))
    return;

  for(int iMode = 0;iMode<*nModes;iMode++)
  {
    const QtbValue *mode = ellipticity.mode(iMode);
    for (int iSample=0; iSample<*nSamples; iSample++)
    {
      if (mode[iSample].isValid())
        *(ellcurve++) = mode[iSample].value();
      else
        *(ellcurve++) = -1;
    }
  }
}

void ellipticity_peak0_rayleigh_(int *nLayers, double *h, double *vp, double *vs, double *rho,
                                 int *nSamples, double *omega, int *nModes, double *peak0)
{
  QtbLayeredModel m(*nLayers);
  int nLayers1 = *nLayers - 1;

  for (int i=0; i<nLayers1; i++)
  {
    m.setH(i, h[i]);
    m.setSlowP(i,1.0/vp[i]);
    m.setSlowS(i,1.0/vs[i]);
    m.setRho(i,rho[i]);
    m.setQp(i,0.0);
    m.setQs(i,0.0);
  }

  m.setSlowP(nLayers1,1.0/vp[nLayers1]);
  m.setSlowS(nLayers1,1.0/vs[nLayers1]);
  m.setRho(nLayers1,rho[nLayers1]);
  m.setQp(nLayers1,0.0);
  m.setQs(nLayers1,0.0);
  m.initCalculation();

  QtbRayleigh rayleigh(&m);
  QVector<double> x(*nSamples);
  for (int i=0; i<*nSamples; i++)
    x[i] = 2.0*M_PI*omega[i];

  QtbDispersion dispersion(*nModes,&x);
  // dispersion.setPrecision( 1e-15 );
  QtbEllipticity ellipticity(*nModes,&x);
  if (!dispersion.calculate(&rayleigh,&ellipticity))
    return;

  QList<double> peaks[1];
  peaks[0] = ellipticity.peaks(0,dispersion,&rayleigh);
  peak0[0] = peaks[0][0];
}
