/***************************************************************************
**
**  Copyright (C) 2002-2009 Marc Wathelet. All rights reserved.
**
**  This file is part of qtbwave.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-01-06
**
***************************************************************************
** Modified by Poggi Valerio (poggi@sed.ethz.ch), 2009-10-26
***************************************************************************/

# ifndef QTBWAVE_H
# define QTBWAVE_H

# ifdef __cplusplus
extern "C" {
# endif 

void dispersion_curve_init_();

void dispersion_curve_rayleigh_(int *nLayers, double *h, double *vp, double *vs, double *rho,
                                int *nSamples, double *omega, int *nModes, double *velocity);
void dispersion_curve_love_(int *nLayers, double *h, double *vp, double *vs, double *rho,
                            int *nSamples, double *omega, int *nModes, double *velocity);
void ellipticity_curve_rayleigh_(int *nLayers, double *h, double *vp, double *vs, double *rho,
                                 int *nSamples, double *omega, int *nModes, double *ellcurve);
void ellipticity_peak0_rayleigh_(int *nLayers, double *h, double *vp, double *vs, double *rho,
                                 int *nSamples, double *omega, int *nModes, double *peak0);
# ifdef __cplusplus
}
# endif 

# endif
